/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.vpd;

import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.base.vpd.VpdErrorIds;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.mediasvc.InvalidFileSystemException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceLockException;
import com.ibm.hwmca.fw.mediasvc.MediaServices;
import com.ibm.hwmca.fw.mediasvc.MediaWriteProtectedException;
import com.ibm.hwmca.fw.mediasvc.NoMediaPresentException;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.rsf.RemoteSupportFacility;
import com.ibm.hwmca.fw.rsf.RsfRequest;
import com.ibm.hwmca.fw.task.HwmcaPanelTasklet;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.FileUtilities;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.rsf.TopologyRequestBody;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;

public abstract class AbstractVpd
implements VpdErrorIds,
CommonMsgInterface {
    private static final String TRACE_MASKT = "HCONVPDT";
    private static final String TRACE_MASKF = "HCONVPDF";
    private static final String TRACE_MASKD = "HCONVPDD";
    private static final String VPD_RECORD_LENGTH = "129";
    private static final String RESERVED = "          ";
    private static final String BLANK = " ";
    private static final String PERIOD = ".";
    private static final String FEXT = ".dat";
    private static final String HEADER_END = "#";
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final int BLANKS_LENGTH = 84;
    private static final int TIMESTAMP_OFFSET = 17;
    private static final int TIMESTAMP_LENGTH = 14;
    public static final int VPD_REC_LENGTH = 129;
    public static final String ZERO = "0";
    private String description;
    private String numVpdRecords;
    private String headerTimeStamp;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getNumVpdRecords() {
        return this.numVpdRecords;
    }

    public void setNumVpdRecords(String numRecords) {
        this.numVpdRecords = numRecords;
    }

    public String getHeaderTimeStamp() {
        return this.headerTimeStamp;
    }

    public void setHeaderTimeStamp(String timeStamp) {
        this.headerTimeStamp = timeStamp;
    }

    public byte[] readFileContent(String qfn) throws HException {
        byte[] fileContents;
        try {
            BufferedInputStream file = new BufferedInputStream(new FileInputStream(qfn));
            fileContents = new byte[(int)new File(qfn).length()];
            file.read(fileContents);
            file.close();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception during AbstractVpd.readFileContent()");
            Trace.trace(TRACE_MASKF, e);
            HException hExc = new HException(e);
            new FrameworkLog(VpdErrorIds.TRANSMITVPD_LOGINFO, 31004, hExc).log();
            throw hExc;
        }
        return fileContents;
    }

    public String readPartialFileContent(int start, int num, String qfn) throws HException {
        String fileContents = null;
        try {
            if (new File(qfn).length() != 0L) {
                BufferedReader brFile = new BufferedReader(new InputStreamReader(new FileInputStream(qfn)));
                brFile.skip(start);
                fileContents = brFile.readLine().substring(0, num);
                brFile.close();
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception during AbstractVpd.readPartialFileContent()");
            Trace.trace(TRACE_MASKF, e);
            HException hExc = new HException(e);
            new FrameworkLog(VpdErrorIds.TRANSMITVPD_LOGINFO, 31007, hExc).log();
            throw hExc;
        }
        return fileContents;
    }

    public String getTimeStamp() {
        UserContext userContext = UserContext.getCurrentUserContext();
        GregorianCalendar time = new GregorianCalendar(userContext.getTimeZone(), userContext.getLocale());
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMddhhmmss", userContext.getLocale());
        dateFormatter.setTimeZone(userContext.getTimeZone());
        String currentTod = dateFormatter.format(time.getTime());
        this.setHeaderTimeStamp(currentTod);
        return currentTod;
    }

    public void writeFileHeader(DataOutputStream vpdFile) throws HException {
        try {
            int i;
            vpdFile.writeBytes(this.getDescription());
            vpdFile.writeByte(0);
            vpdFile.writeBytes(VPD_RECORD_LENGTH);
            vpdFile.writeByte(0);
            for (i = this.getNumVpdRecords().length(); i < 5; ++i) {
                vpdFile.writeBytes(ZERO);
            }
            vpdFile.writeBytes(this.getNumVpdRecords());
            vpdFile.writeByte(0);
            vpdFile.writeBytes(this.getTimeStamp());
            vpdFile.writeByte(0);
            vpdFile.writeBytes(RESERVED);
            for (i = 0; i < 84; ++i) {
                vpdFile.writeBytes(BLANK);
            }
            vpdFile.writeBytes(HEADER_END);
            vpdFile.writeByte(13);
            vpdFile.writeByte(10);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "Exception during AbstractVpd.writeFileHeader()");
            Trace.trace(TRACE_MASKF, e);
            HException hExc = new HException(e);
            new FrameworkLog(VpdErrorIds.TRANSMITVPD_LOGINFO, 31003, hExc).log();
            throw hExc;
        }
    }

    public void doRsfTransmit(RemoteSupportFacility rsf, String qfn) throws HException {
        try {
            if (rsf != null && rsf.isCallHomeEnabled() && rsf.isCallHomeServerAvailable()) {
                TopologyRequestBody request = new TopologyRequestBody();
                request.initializeMachineInformation();
                request.initializeUpdateList();
                ArrayList<File> vpdFiles = new ArrayList<File>();
                vpdFiles.add(new File(qfn));
                request.setFileList(vpdFiles);
                RsfRequest rsfRequest = rsf.newRequestInstance(request, "com.ibm.hwmca.base.vpd.TransmitVpdRsfResults", new LocalizableText(BaseTextBundle.getBundleName(), "vpd.transmit.title"));
                rsfRequest.submit();
            } else {
                Trace.trace(TRACE_MASKF, "Transmit can't be done!");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception during AbstractVpd.doRsfTransmit()");
            Trace.trace(TRACE_MASKF, e);
            HException hExc = e instanceof HException ? (HException)e : new HException(e);
            new FrameworkLog(VpdErrorIds.TRANSMITVPD_LOGINFO, 31006, hExc).log();
            throw hExc;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean transmitToDiskette(HwmcaPanelTasklet hpt, String fromQFileName, String toFileName, int numFiles) throws HException {
        block27: {
            disketteDevice = null;
            Trace.trace("HCONVPDT", "-> AbstractVpd.transmitToDiskette()");
            Trace.trace("HCONVPDF", "From File =" + fromQFileName + ", To File = " + toFileName);
            title = new BaseMessageTitle("TVPD8001");
            messageText = new BaseMessageText[]{new BaseMessageText("TVPDDBEG")};
            options = new LocalizableText[]{CommonMsgInterface.OK_BUTTON, CommonMsgInterface.CANCEL_BUTTON};
            try {
                ms = MediaServices.getMediaServices();
                disketteId = ms.getPreferredDevice(1);
                if (disketteId != null) {
                    cancelPressed = false;
                    quitDueToError = false;
                    for (i = 1; i <= numFiles && !cancelPressed; ++i) {
                        if (i == 1) {
                            newFromQFileName = fromQFileName;
                        } else {
                            newFromQFileName = fromQFileName.substring(0, fromQFileName.indexOf(".")).concat(Integer.toString(i)).concat(".dat");
                            Trace.trace("HCONVPDF", "new from File =" + newFromQFileName);
                        }
                        fileCopied = false;
                        do {
                            Trace.trace("HCONVPDF", "before call to show mesage box");
                            buttonPressed = hpt.showMessageBox(false, title, messageText, messageText[0].getMsgId(), messageText[0].getMsgType(), options);
                            Trace.trace("HCONVPDF", "after call to show mesage box, buttonPressed = " + buttonPressed);
                            if (buttonPressed.equals(CommonMsgInterface.OK_BUTTON)) {
                                if (!quitDueToError) {
                                    try {
                                        disketteDevice = ms.requestLock(new LocalizableText(BaseTextBundle.getBundleName(), "vpd.transmit.title"), disketteId);
                                        disketteDevice.mountReadWrite();
                                        checkFile = new File(disketteDevice.getMountPoint().toString());
                                        if (checkFile.list().length != 0) {
                                            Trace.trace("HCONVPDF", "Disk not empty, put up message asking them to insert empty, formatted disk.");
                                            messageText[0] = new BaseMessageText("TVPDEMTY");
                                        }
                                        toQFileName = disketteDevice.getMountPoint().toString() + File.separator + toFileName;
                                        FileUtilities.copy(newFromQFileName, toQFileName);
                                        fileCopied = true;
                                    }
                                    catch (IOException io) {
                                        if (!io.getMessage().startsWith("No space left on device")) ** GOTO lbl67
                                        messageText[0] = new BaseMessageText("TVPDFULL");
                                    }
                                    catch (MediaDeviceLockException mde) {
                                        messageText[0] = new BaseMessageText("Diskette device in use");
                                        hExc = new HException("Diskette Device in use - can't acquire lock.");
                                        new FrameworkLog(VpdErrorIds.TRANSMITVPD_LOGINFO, 31009, hExc).log();
                                    }
                                    catch (NoMediaPresentException mde) {
                                        messageText[0] = new BaseMessageText("TVPDNOFM");
                                    }
                                    catch (MediaWriteProtectedException mde) {
                                        messageText[0] = new BaseMessageText("TVPDWPRO");
                                    }
                                    catch (InvalidFileSystemException mde) {
                                        messageText[0] = new BaseMessageText("TVPDINVL");
                                    }
                                    catch (MediaDeviceException mde) {
                                        throw mde;
                                    }
                                    catch (HException e) {
                                        throw e;
                                    }
                                } else {
                                    cancelPressed = true;
                                }
                            } else if (buttonPressed.equals(CommonMsgInterface.CANCEL_BUTTON) || buttonPressed.equals(CommonMsgInterface.CLOSE_BUTTON)) {
                                cancelPressed = true;
                                Trace.trace("HCONVPDF", "Cancel pressed!!!");
                            }
lbl67:
                            // 12 sources

                            try {
                                if (disketteDevice == null) continue;
                                disketteDevice.unlock();
                                disketteDevice = null;
                            }
                            catch (MediaDeviceException mde) {
                                throw mde;
                            }
                            catch (HException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                throw new HException(e);
                            }
                        } while (!cancelPressed && !fileCopied);
                        messageText[0] = new BaseMessageText("TVPDNEXT");
                    }
                    if (disketteDevice != null) {
                        disketteDevice.unlock();
                        disketteDevice = null;
                    }
                    break block27;
                }
                Trace.trace("HCONVPDF", "AbstractVpd.transmitToDiskette(), disketteId = null");
                hExc = new HException("Diskette id is null");
                new FrameworkLog(VpdErrorIds.TRANSMITVPD_LOGINFO, 31008, hExc).log();
                throw hExc;
            }
            catch (Exception e) {
                Trace.trace("HCONVPDF", "Exception during AbstractVpd.transmitToDiskette()");
                Trace.trace("HCONVPDF", e);
                if (disketteDevice != null) {
                    disketteDevice.unlock();
                    disketteDevice = null;
                }
                hExc = e instanceof HException != false ? (HException)e : new HException(e);
                new FrameworkLog(VpdErrorIds.TRANSMITVPD_LOGINFO, 31005, hExc).log();
                throw hExc;
            }
        }
        Trace.trace("HCONVPDT", "<- AbstractVpd.transmitToDiskette()");
        return (boolean)var10_13;
    }
}

